<?php

use \UtillzCore\Inc\Src\Listing\Listing;
use \UtillzCore\Inc\Src\Listing\Conversation;
use \UtillzCore\Inc\Src\User;

defined('ABSPATH') || exit;

$listing = new Listing( Ucore()->get('ulz_listing_id') );
$last_message = Conversation::get_last_message( get_the_ID() );
$conversation = new Conversation( get_the_ID() );
$receiver_userdata = get_userdata( $conversation->receiver_id );

if( ! $last_message ) {
    return;
}

$user = new User( $last_message->sender_id );
$userdata = $user->get_userdata();

$is_active = ( $last_message->active && ( (int) $last_message->sender_id !== get_current_user_id() ) );

?>

<tr class="<?php echo $is_active ? 'ulz--active' : ''; ?>">
    <td class="ulz--cell-image">
        <div class="ulz--image">
            <a href="<?php the_permalink( $listing->id ); ?>">
                <?php $image = $listing->get_first_from_gallery( 'thumbnail' ); ?>
                <?php if( $image ): ?>
                    <?php echo '<img src="' . esc_url( $image ) . '" alt="">'; ?>
                <?php else: ?>
                    <?php echo Ucore()->dummy( 'person', 'material-icons', 100 ); ?>
                <?php endif; ?>
            </a>
        </div>
    </td>
    <td class="ulz--cell-meta">
        <?php if( isset( $receiver_userdata->display_name ) ): ?>
            <p class="ulz-mb-0">
                <?php echo esc_html( $receiver_userdata->display_name ); ?>
            </p>
        <?php endif; ?>
        <time class="ulz--time">
            <?php echo date_i18n( get_option('date_format') . ' ' . get_option('time_format'), strtotime( $last_message->created_at ) ); ?>
        </time>
    </td>
    <td class="ulz--cell-name">
        <?php if( $listing->id ): ?>
            <h4 class="ulz--name">
                <?php echo wp_trim_words( get_the_title( $listing->id ), 8 ); ?>
            </h4>
        <?php endif; ?>
    </td>
    <td class="ulz--cell-actions">
        <div class="ulz--actions">
            <ul>
                <?php if( $listing->id ): ?>
                    <li>
                        <a href="<?php the_permalink( $listing->id ); ?>" target="_blank">
                            <?php echo utillz_core()->icon->get( 'place', 'material-icons' ); ?>
                        </a>
                    </li>
                <?php endif; ?>
                <li>
                    <a href="#" class="ulz--toggle-active ulz--click" data-modal="conversation" data-params='{"id":<?php the_ID(); ?>}'>
                        <?php echo utillz_core()->icon->get( 'chat', 'material-icons' ); ?>
                    </a>
                </li>
            </ul>
        </div>
    </td>
</tr>
